#! /bin/sh
### BEGIN INIT INFO
# Provides:          EXE_NAME
# Required-Start:    $network
# Required-Stop:
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: LCN pchk
### END INIT INFO

# Author: Issendorff KG

PATH=/sbin:/bin:INSTALL_DIR
DESC="LCN pchk"
NAME=EXE_NAME
DAEMON=INSTALL_DIR/$NAME
DAEMON_ARGS="-f CONFIG_DIR/lcnpchk.xml -d DATA_DIR -l LOG_DIR"
SCRIPTNAME=/etc/init.d/$NAME
NICELEVEL=-10
PIDFILE=/var/run/lcnpchk.pid

# Exit if the package is not installed
[ -x "$DAEMON" ] || exit 0

# Load the VERBOSE setting and other rcS variables
. /lib/init/vars.sh

# Define LSB log_* functions.
# Depend on lsb-base (>= 3.2-14) to ensure that this file is present
# and status_of_proc is working.
. /lib/lsb/init-functions

#
# Function that starts the daemon/service
#
do_start()
{
    if start-stop-daemon --start --quiet --oknodo --nicelevel $NICELEVEL --pidfile $PIDFILE --exec $DAEMON -- $DAEMON_ARGS; then
            cat /dev/null > /var/run/lcnpchk.pid
            pidof lcnpchk >> /var/run/lcnpchk.pid
        log_end_msg 0
    else
        log_end_msg 1
    fi

}

#
# Function that stops the daemon/service
#
do_stop()
{
	# Return
	#   0 if daemon has been stopped
	#   1 if daemon was already stopped
	#   2 if daemon could not be stopped
	#   other if a failure occurred
	if start-stop-daemon --stop --exec $DAEMON --pidfile $PIDFILE; then
		rm /var/run/lcnpchk.pid
		return "$?"
	fi
}

case "$1" in
  start)
	log_daemon_msg "Starting $DESC" "$NAME"
	do_start
	case "$?" in
		0|1) log_end_msg 0 ;;
		2) log_end_msg 1 ;;
	esac
	;;
  stop)
	log_daemon_msg "Stopping $DESC" "$NAME"
	do_stop
	case "$?" in
		0|1) log_end_msg 0 ;;
		2) log_end_msg 1 ;;
	esac
	;;
  status)
	status_of_proc "$DAEMON" "$NAME" && exit 0 || exit $?
	;;
  restart|force-reload)
	log_daemon_msg "Restarting $DESC" "$NAME"
	do_stop
	case "$?" in
	  0|1)
		do_start
		case "$?" in
			0) log_end_msg 0 ;;
			1) log_end_msg 1 ;; # Old process is still running
			*) log_end_msg 1 ;; # Failed to start
		esac
		;;
	  *)
		# Failed to stop
		log_end_msg 1
		;;
	esac
	;;
  *)
	echo "Usage: $SCRIPTNAME {start|stop|status|restart|force-reload}" >&2
	exit 3
	;;
esac

:
