#!/bin/bash
echo "

Willkommen beim Konfigurationsscript der LCN-PCHK
Bitte alle Eingaben vollstaedig ausfuellen!

"
read -p "Bitte den Lizenznamen eingeben
:" lizenzname
read -p "Bitte den Lizenzkey eingeben
(Ohne Leerzeichen und Trennstriche. Sollte ein & enthalten sein, muss dies durch ein &amp; erstetzt werden!)
:" lizenz
read -p "PCHK Benutzername eingeben:" user
read -p "Bitte Passwort eingeben:" pass
password=`echo -n $pass | md5sum | awk '{print $1}'` 

echo "<?xml version=\"1.0\" encoding=\"UTF-8\" ?> 
 <LcnPchkConfiguration xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"lcnpchkconfig.xsd\">
  <Header>
   <Version major=\"1\" minor=\"0\" /> 
    <Generator>LCN-PCHK 3.2</Generator> 
   </Header>
  <Global>
   <Language>de</Language> 
  </Global>
  <LicenseInformation>
   <Licensee>$lizenzname</Licensee> 
   <LicenseKeys>
    <LicenseKey xsi:type=\"AutoKey\">$lizenz</LicenseKey> 
   </LicenseKeys>
  </LicenseInformation>
  <LcnRealTimeClockSync xsi:type=\"SyncAutoDetect\" />
  <Communication>
   <LCNPort>ttyUSB0</LCNPort> 
   <HostPort>TCP/IP</HostPort> 
   <TCPPortNum>4114</TCPPortNum> 
   <TCPInactivityTimeout>1800</TCPInactivityTimeout> 
   <User>$user:$password</User> 
   <HostId>4</HostId> 
   <RemoteConfigurationXmlRpcPort>4220</RemoteConfigurationXmlRpcPort> 
  </Communication>
 </LcnPchkConfiguration>" > ./lcnpchk.xml
echo "

PCHK wird jetzt installiert...

" 
set -e

EXE_NAME=lcnpchk
INSTALL_DIR=/usr/bin
CONFIG_DIR=/var/lib/lcnpchk
DATA_DIR=/usr/share/lcnpchk
LOG_DIR=/var/log/lcnpchk
USER=$USER
USER_WITH_GROUP=$USER:$USER
NETWORK_CONFIG_SCRIPT=pchk_network_config.sh
REBOOT_SCRIPT=pchk_reboot.sh

if [ ! -d $CONFIG_DIR ]
then
	echo "Creating config dir (${CONFIG_DIR})"
	sudo mkdir $CONFIG_DIR
	sudo chown $USER_WITH_GROUP $CONFIG_DIR
fi

if [ ! -f $CONFIG_DIR/lcnpchk.xml ]
then
	echo "Copying config file to config dir (${CONFIG_DIR}/lcnpchk.xml)"
	cp lcnpchk.xml $CONFIG_DIR/lcnpchk.xml
fi

echo "Installing binary (${INSTALL_DIR}/${EXE_NAME})"
if [ ! -f $EXE_NAME ]
then
	echo "Can't find executable, please copy it to this directory"
	exit 1
fi
sudo cp $EXE_NAME $INSTALL_DIR/$EXE_NAME
sudo setcap 'cap_sys_time=+ep' $INSTALL_DIR/$EXE_NAME

echo "Installing network config script ($INSTALL_DIR/$NETWORK_CONFIG_SCRIPT)"
sudo cp $NETWORK_CONFIG_SCRIPT $INSTALL_DIR/$NETWORK_CONFIG_SCRIPT
sudo chmod a+x $INSTALL_DIR/$NETWORK_CONFIG_SCRIPT

echo "Installing reboot script ($INSTALL_DIR/$REBOOT_SCRIPT)"
sudo cp $REBOOT_SCRIPT $INSTALL_DIR/$REBOOT_SCRIPT
sudo chmod a+x $INSTALL_DIR/$REBOOT_SCRIPT

echo "Installing data dir (${DATA_DIR})"
sudo mkdir $DATA_DIR
sudo cp -R -t $DATA_DIR Data/*

if [ ! -d $LOG_DIR ]
then
	echo "Creating log dir (${LOG_DIR})"
	sudo mkdir $LOG_DIR
	sudo chown $USER_WITH_GROUP $LOG_DIR
fi

cp init_script_template.sh ${EXE_NAME}_init_script
sed -i "s!EXE_NAME!${EXE_NAME}!g" ${EXE_NAME}_init_script
sed -i "s!DATA_DIR!${DATA_DIR}!g" ${EXE_NAME}_init_script
sed -i "s!LOG_DIR!${LOG_DIR}!g" ${EXE_NAME}_init_script
sed -i "s!CONFIG_DIR!${CONFIG_DIR}!g" ${EXE_NAME}_init_script
sed -i "s!INSTALL_DIR!${INSTALL_DIR}!g" ${EXE_NAME}_init_script
sed -i "s!USER_WITH_GROUP!${USER_WITH_GROUP}!g" ${EXE_NAME}_init_script

echo "Installing init script (/etc/init.d/${EXE_NAME})"
sudo cp ${EXE_NAME}_init_script /etc/init.d/${EXE_NAME}
sudo chmod a+x /etc/init.d/${EXE_NAME}
rm ${EXE_NAME}_init_script

echo "Registering init script"
sudo update-rc.d $EXE_NAME defaults 90

echo "Installing udev rule (/etc/udev/rules.d/50-lcn-pku)"
sudo cp ./50-lcn-pku /etc/udev/rules.d/50-lcn-pku
sudo udevadm control --reload-rules


sudoers_file=/etc/sudoers.d/lcnpchk
echo "Installing sudoers file (${sudoers_file})"
echo "# Allow reboot and interface manipulation via sudo without password so lcnpchk can properly function
$USER ALL=NOPASSWD:${INSTALL_DIR}/${NETWORK_CONFIG_SCRIPT},${INSTALL_DIR}/${REBOOT_SCRIPT}" | sudo tee $sudoers_file > /dev/null
sudo chmod 0440 $sudoers_file
