#!/bin/bash

# Changes the network configuration
# Parameters:
#  $1 = dhcp (0 or 1)
#  $2 = ip
#  $3 = netmask
#  $4 = gatway
#  $5 = dnsServers (space seperated list)
# Exit codes:
#  0 = success
#  1 = invalid parameters
#  2 = Can't write interface file
#  3 = Can't restart interface

INTERFACE=eth0
INTERFACE_FILE="/etc/network/interfaces.d/$INTERFACE"
DHCP="$1"
IP="$2"
NETMASK="$3"
GATEWAY="$4"
DNSSERVERS="$5"

if [[ $DHCP != "1" && $DHCP != "0" ]]
then
	exit 1
fi

if [[ $DHCP == "0" ]]
then
	if [[ $IP == "" || $NETMASK == "" || $GATEWAY == "" || $DNSSERVERS == "" ]]
	then
		exit 1
	fi
fi

temp="$(mktemp)"

echo "auto eth0" > $temp
if [ $DHCP == "1" ]
then
	echo "face eth0 inet dhcp" >> $temp
elif [ $DHCP == "0" ]
then
	echo "iface eth0 inet static" >> $temp
	echo "	address $IP" >> $temp
	echo "	netmask $NETMASK" >> $temp
	echo "	gateway $GATEWAY" >> $temp
fi
echo "	dns-nameservers $DNSSERVERS" >> $temp
echo "	up route add -net 224.0.0.0 netmask 224.0.0.0 dev eth0" >> $temp
chmod a+r $temp
mv -T $temp $INTERFACE_FILE || exit 2

ifdown $INTERFACE || exit 3
dhclient || exit 3
ifup $INTERFACE || exit 3
