EXE_NAME=lcnpchk
INSTALL_DIR=/usr/bin
DATA_DIR=/usr/share/lcnpchk
NETWORK_CONFIG_SCRIPT=pchk_network_config.sh
REBOOT_SCRIPT=pchk_reboot.sh

if [ -f $INSTALL_DIR/$EXE_NAME ]
then
	echo "Removing installed binary (${INSTALL_DIR}/${EXE_NAME})"
	sudo rm $INSTALL_DIR/$EXE_NAME
fi

if [ -f $INSTALL_DIR/$NETWORK_CONFIG_SCRIPT ]
then
	echo "Removing installed network config script ($INSTALL_DIR/$NETWORK_CONFIG_SCRIPT)"
	sudo rm $INSTALL_DIR/$NETWORK_CONFIG_SCRIPT
fi

if [ -f $INSTALL_DIR/$REBOOT_SCRIPT ]
then
	echo "Removing installed reboot script ($INSTALL_DIR/$REBOOT_SCRIPT)"
	sudo rm $INSTALL_DIR/$REBOOT_SCRIPT
fi

if [ -d $DATA_DIR ]
then
	echo "Remving data dir (${DATA_DIR})"
	sudo rm -r $DATA_DIR
fi

if [ -f /etc/init.d/$EXE_NAME ]
then
	echo "Removing init script (/etc/init.d/${EXE_NAME})"
	sudo rm /etc/init.d/$EXE_NAME
fi

echo "Unregistering init script"
sudo update-rc.d $EXE_NAME remove

if [ -f /etc/udev/rules.d/50-lcn-pku ]
then
	echo "Uninstalling udev rule (/etc/udev/rules.d/50-lcn-pku)"
	sudo rm /etc/udev/rules.d/50-lcn-pku
	sudo udevadm control --reload-rules
fi


sudoers_file=/etc/sudoers.d/lcnpchk
echo "Removing sudoers file (${sudoers_file})"
sudo rm -f $sudoers_file
